import java.awt.Frame;
import java.util.Vector;
import java.awt.Scrollbar;
import java.awt.BorderLayout;
import java.util.Enumeration;
import java.awt.Rectangle;
import java.awt.Graphics;
import types.DataClass;
import types.Transaction;
import java.awt.Toolkit;
import java.awt.Event;
import types.Rahmen;


public class HistoryPanel extends MenuPanel {
    public Vector  sender_dc;
    public Vector  receiver_dc;
    public Vector  transaction;

    int             m_iAnzahl;
    HistoryView     m_View;

    Scrollbar       m_Scrollbar;

    public HistoryPanel() {
        setLayout(new BorderLayout(10,10));
        sender_dc = new Vector(50);
        receiver_dc = new Vector(50);
        transaction = new Vector(50);
        m_iAnzahl = 20;
        m_View = new HistoryView(this);
        add("Center",m_View);
        m_Scrollbar = new Scrollbar(Scrollbar.VERTICAL,0,100,0,1000);
        add("East",m_Scrollbar);
        // create the property dialogbox
		Frame frame = new Frame();
		m_Dlg = new HistoryProperties(frame);
		m_Dlg.setResizable(true);
		m_Dlg.resize(250,300);
		m_Dlg.setResizable(false);
    }

    public void addWindow(DataClass senderData,DataClass receiverData) {
        try {
            sender_dc.addElement(senderData.clone());
            receiver_dc.addElement(receiverData.clone());
        }
        catch (CloneNotSupportedException e) {;};
        if (sender_dc.size()>(m_iAnzahl+1)) {
            sender_dc.removeElementAt(0);
            receiver_dc.removeElementAt(0);
        }
        Rectangle frame = m_View.bounds();
        int iMax = m_View.height(sender_dc.size())-frame.height;
        if (iMax<0)
            iMax =0;
        m_Scrollbar.setPageIncrement(200);
        m_Scrollbar.setLineIncrement(100);
        m_Scrollbar.setValues(iMax,frame.height,0,iMax);
        m_View.m_iOffset = iMax;
    }
    public void addTransaction(Transaction trans) {
        transaction.addElement(trans);
        if (transaction.size()>(m_iAnzahl)) {
            transaction.removeElementAt(0);
        }
        m_View.repaint();
    }
    public void clear() {
        // Clear all windows and transactions
        transaction.removeAllElements();
        sender_dc.removeAllElements();
        receiver_dc.removeAllElements();
        // put the actual senders and receivers window on top
        addWindow(Global.channel.stationA.protocol().sendWindow,
                  Global.channel.stationB.protocol().receiveWindow);
        m_View.m_iOffset=0;
        m_View.repaint();
    }
    public void setAnzahl(int iAnzahl) {
        clear();
        m_iAnzahl = iAnzahl;
    }
    public int getAnzahl() {
        return(m_iAnzahl);
    }
    public boolean handleEvent(Event e) {
         if (e.target == m_Scrollbar) {
            switch (e.id) {
                case Event.SCROLL_LINE_UP:
                case Event.SCROLL_LINE_DOWN:
                case Event.SCROLL_PAGE_UP:
                case Event.SCROLL_PAGE_DOWN:
                case Event.SCROLL_ABSOLUTE:
                    m_View.m_iOffset = ((Integer)e.arg).intValue();
                    m_View.repaint();
                    return(true);
            }
        }
        if (e.id==Event.KEY_PRESS) {//&&(e.key==Event.DOWN)) {
            m_View.m_iOffset+=20;
            m_Scrollbar.setValue(m_View.m_iOffset);
            m_View.m_iOffset=m_Scrollbar.getValue();
            m_View.repaint();
        }

        return(super.handleEvent(e));
    }
}

class HistoryView extends MenuPanel {
    int             m_iOffset;
    int             m_iHeight;
    int             m_iWidth;
    int             m_iSpace;
    HistoryPanel    m_hf;

    public HistoryView(HistoryPanel hf) {
        m_iOffset = 0;
        m_hf = hf;
        m_iHeight = 40;
        m_iWidth = 40;
        m_iSpace = 20;
    }
    public int height(int iAnzahl) {
       return(iAnzahl*(m_iHeight+m_iSpace));
    }
    public void paint(Graphics g) {
       // System.out.println("Paint..");
        Rectangle bnds=bounds();
        int iOffset = -m_iOffset+10;
        g.drawRect(0,0,bnds.width-1,bnds.height-1);
        Rectangle rahmen = new Rectangle(10,iOffset,m_iWidth,m_iHeight);
        for (Enumeration e = m_hf.sender_dc.elements();e.hasMoreElements();) {
            DataClass data = (DataClass) e.nextElement();
            if (rahmen.intersects(bnds)) {
                Wheel wheel = new Wheel((DataClass)data);
                wheel.paint(g,rahmen);
            }
            rahmen.translate(0,m_iHeight+m_iSpace);
        }
        rahmen = new Rectangle(bnds.width-m_iWidth-10,iOffset,m_iWidth,m_iHeight);
        for (Enumeration e = m_hf.receiver_dc.elements();e.hasMoreElements();) {
            DataClass data = (DataClass) e.nextElement();
            if (rahmen.intersects(bnds)) {
                Wheel wheel = new Wheel((DataClass)data);
                wheel.paint(g,rahmen);
            }
            rahmen.translate(0,m_iHeight+m_iSpace);
        }
        // Draw Transactions
        int iStartY = iOffset+20;
        for (Enumeration e = m_hf.transaction.elements();e.hasMoreElements();) {
            Transaction t = (Transaction) e.nextElement();
            // Draw transactions A->B
            rahmen = new Rectangle(m_iWidth+20,iStartY,bnds.width-2*m_iWidth-40,30);
            if (rahmen.intersects(bnds)) {
                for (Enumeration e2 = t.a_to_b.elements();e2.hasMoreElements();) {
                    Rahmen frame = (Rahmen) e2.nextElement();
                    if (!frame.Destroyed()) {
                        g.drawLine(rahmen.x,rahmen.y,rahmen.x+rahmen.width,rahmen.y+rahmen.height);
                        Rectangle circle = new Rectangle(rahmen.x+rahmen.width-15,rahmen.y+rahmen.height-15,30,30);
                        g.fillArc(circle.x,circle.y,circle.width,circle.height,158,40);
                    }
                    else {
                        g.drawLine(rahmen.x,rahmen.y,rahmen.x+rahmen.width/2,rahmen.y+rahmen.height/2);
                        Rectangle circle = new Rectangle(rahmen.x+rahmen.width/2-15,rahmen.y+rahmen.height/2-15,30,30);
                        g.fillArc(circle.x,circle.y,circle.width,circle.height,158,40);
                        g.drawImage(Global.m_imgBlitz,rahmen.x+rahmen.width/2,rahmen.y+rahmen.height/2-Global.m_imgBlitz.getHeight(this)/2,this);
                    }
                    StringBuffer temp = new StringBuffer(0);
                    temp.append(frame.data());
                    g.drawString("F: "+Integer.toString(frame.seqNr())+","+temp.toString(),rahmen.x+rahmen.width/4,rahmen.y+rahmen.height/4);
                    rahmen.translate(0,15);
                }
            }
            // Draw timeout Image
            if (t.timeoutA()>=0) {
                g.drawImage(Global.m_imgClock,rahmen.x,rahmen.y,this);
                g.drawString(Integer.toString(t.timeoutA()),rahmen.x,rahmen.y);
            }
            // Draw transactions B->A
            rahmen = new Rectangle(m_iWidth+20,iStartY,bnds.width-2*m_iWidth-40,30);
            if (rahmen.intersects(bnds)) {
                for (Enumeration e2 = t.b_to_a.elements();e2.hasMoreElements();) {
                    Rahmen frame = (Rahmen) e2.nextElement();
                    if (!frame.Destroyed()) {
                        g.drawLine(rahmen.x+rahmen.width,rahmen.y,rahmen.x,rahmen.y+rahmen.height);
                        Rectangle circle = new Rectangle(rahmen.x-15,rahmen.y+rahmen.height-15,30,30);
                        g.fillArc(circle.x,circle.y,circle.width,circle.height,342,40);
                    }
                    else {
                        g.drawLine(rahmen.x+rahmen.width,rahmen.y,rahmen.x+rahmen.width/2,rahmen.y+rahmen.height/2);
                        Rectangle circle = new Rectangle(rahmen.x+rahmen.width/2-15,rahmen.y+rahmen.height/2-15,30,30);
                        g.fillArc(circle.x,circle.y,circle.width,circle.height,342,40);
                        g.drawImage(Global.m_imgBlitz,rahmen.x-Global.m_imgBlitz.getWidth(this)+rahmen.width/2,rahmen.y+rahmen.height/2-Global.m_imgBlitz.getHeight(this)/2,this);
                    }
                    g.drawString("A: "+Integer.toString(frame.seqNrAck()),rahmen.x+3*rahmen.width/4,rahmen.y+3*rahmen.height/4-20);
                    rahmen.translate(0,15);
                }
            }
            // Draw timeout Image
            if (t.timeoutB()>=0) {
                g.drawImage(Global.m_imgClock,rahmen.x+rahmen.width-Global.m_imgClock.getWidth(this),rahmen.y,this);
                g.drawString(Integer.toString(t.timeoutB()),rahmen.x+rahmen.width-Global.m_imgClock.getWidth(this),rahmen.y);
            }
            iStartY+=m_iWidth+m_iSpace;
         }
     }
}

